

$RequiredVersion = [version]"144.0.7559.60"
$ChromePath      = "C:\Program Files\Google\Chrome\Application"
$LogFile         = "C:\Ivanti\Logs\ChromeVersionCleanup.log"

# Create log folder
New-Item -ItemType Directory -Path (Split-Path $LogFile) -Force | Out-Null

function Write-Log {
    param ($Message)
    $Time = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    "$Time - $Message" | Out-File -Append -FilePath $LogFile
}

Write-Log "=== Chrome cleanup started ==="

# Check Chrome existence
if (-not (Test-Path "$ChromePath\chrome.exe")) {
    Write-Log "Chrome not found. Exit."
    exit 0
}

Start-Process msiexec.exe -ArgumentList "/i `"\\10.41.32.18\Shared\B\Chrome\Chrome-144.0.7559.60.msi`"", "/qn", "/norestart" -Wait -NoNewWindow

# Get current version
$CurrentVersion = [version](Get-Item "$ChromePath\chrome.exe").VersionInfo.ProductVersion
Write-Log "Detected Chrome version: $CurrentVersion"

# Compare version
if ($CurrentVersion -lt $RequiredVersion) {
    Write-Log "Chrome version too old. Uninstall required."

    $Uninstall = Get-ItemProperty `
     "HKLM:\Software\Microsoft\Windows\CurrentVersion\Uninstall\*" ,
     "HKLM:\Software\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\*" `
     -ErrorAction SilentlyContinue |
     Where-Object { $_.DisplayName -like "Google Chrome*" }

    if ($Uninstall) {
        Write-Log "Running uninstall..."
        Start-Process "cmd.exe" `
        "/c $($Uninstall.UninstallString) /silent /norestart" `
        -Wait
        Write-Log "Uninstall completed"
    } else {
        Write-Log "Uninstall entry not found"
    }

    exit 0
}

Write-Log "Chrome version OK. Cleaning old folders only."

# Remove old version folders
Get-ChildItem $ChromePath -Directory |
Where-Object {
    $_.Name -match '^\d+\.' -and ([version]$_.Name -lt $CurrentVersion)
} |
ForEach-Object {
    Write-Log "Removing old folder: $($_.Name)"
    Remove-Item $_.FullName -Recurse -Force -ErrorAction SilentlyContinue
}

Write-Log "Cleanup completed successfully"



exit 0
